%------------------------------------------------------------------------------
% File     : SEV282^5 : TPTP v7.4.0. Bugfixed v6.2.0.
% Domain   : Set Theory
% Problem  : TPS problem TTTP6100
% Version  : Especial.
% English  : 

% Refs     : [Bro09] Brown (2009), Email to Geoff Sutcliffe
% Source   : [Bro09]
% Names    : tps_000 [Bro09]
%          : TTTP6100 [TPS]

% Status   : Theorem
% Rating   : 0.00 v6.2.0
% Syntax   : Number of formulae    :    7 (   0 unit;   3 type;   3 defn)
%            Number of atoms       :   27 (   4 equality;  16 variable)
%            Maximal formula depth :   11 (   6 average)
%            Number of connectives :   17 (   2   ~;   0   |;   3   &;  10   @)
%                                         (   0 <=>;   2  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   21 (  21   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    5 (   3   :;   0   =)
%            Number of variables   :    9 (   0 sgn;   2   !;   2   ?;   5   ^)
%                                         (   9   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : This problem is from the TPS library. Copyright (c) 2009 The TPS
%            project in the Department of Mathematical Sciences at Carnegie
%            Mellon University. Distributed under the Creative Commons copyleft
%            license: http://creativecommons.org/licenses/by-sa/3.0/
% Bugfixes : v5.2.0 - Added missing type declarations.
%          : v6.2.0 - Reordered definitions.
%------------------------------------------------------------------------------
thf(cNAT_type,type,(
    cNAT: ( ( $i > $o ) > $o ) > $o )).

thf(cSUCC_type,type,(
    cSUCC: ( ( $i > $o ) > $o ) > ( $i > $o ) > $o )).

thf(cZERO_type,type,(
    cZERO: ( $i > $o ) > $o )).

thf(cZERO_def,definition,
    ( cZERO
    = ( ^ [Xp: $i > $o] :
          ~ ( ? [Xx: $i] :
                ( Xp @ Xx ) ) ) )).

thf(cSUCC_def,definition,
    ( cSUCC
    = ( ^ [Xn: ( $i > $o ) > $o,Xp: $i > $o] :
        ? [Xx: $i] :
          ( ( Xp @ Xx )
          & ( Xn
            @ ^ [Xt: $i] :
                ( ( Xt != Xx )
                & ( Xp @ Xt ) ) ) ) ) )).

thf(cNAT_def,definition,
    ( cNAT
    = ( ^ [Xn: ( $i > $o ) > $o] :
        ! [Xp: ( ( $i > $o ) > $o ) > $o] :
          ( ( ( Xp @ cZERO )
            & ! [Xx: ( $i > $o ) > $o] :
                ( ( Xp @ Xx )
               => ( Xp @ ( cSUCC @ Xx ) ) ) )
         => ( Xp @ Xn ) ) ) )).

thf(cTTTP6100,conjecture,
    ( cNAT @ cZERO )).

%------------------------------------------------------------------------------
